﻿namespace Eliza
{
    /// <summary>
    /// A speech pattern.
    /// </summary>
    class Pattern
    {
        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="Pattern"/> class.
        /// </summary>
        /// <param name="phraseToMatch">The phrase to match.</param>
        public Pattern
            (string phraseToMatch)
        {
            this.PhraseToMatch = phraseToMatch;
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the phrase to match.
        /// </summary>
        public string PhraseToMatch {
            get;
            private set;
        }

        #endregion

        #region Public methods

        /// <summary>
        /// Checks if the pattern matches the user's input.
        /// </summary>
        /// <param name="input">The user's input.</param>
        /// <returns><see langword="true"/> if the pattern matches the user's input, otherwise <see langword="false"/>.</returns>
        public bool MatchesInput
            (string input)
        {
            // Stubbed for now
            return false;
        }

        /// <summary>
        /// Generates a human-like response.
        /// </summary>
        /// <returns>The response.</returns>
        public string GenerateResponse()
        {
            // Stubbed for now
            return null;
        }

        #endregion
    }
}
